/*
 * Decompiled with CFR 0.152.
 */
package calcuator;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MainCalculator
extends JFrame {
    private JTextField broadcastAddress;
    private JButton calBtn;
    private JTextField cidrValue;
    private JTextField hostsPSubnet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JTextField networkAddress;
    private JTextField networkClass;
    private JTextField noSubnets;
    private JTextField oct1;
    private JTextField oct2;
    private JTextField oct3;
    private JTextField oct4;
    private JButton resetBtn;
    private JTextField subnetMask;

    public MainCalculator() {
        this.initComponents();
        this.setTitle("SubNet Calculator");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.oct1 = new JTextField();
        this.oct2 = new JTextField();
        this.oct3 = new JTextField();
        this.oct4 = new JTextField();
        this.jLabel2 = new JLabel();
        this.cidrValue = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.networkClass = new JTextField();
        this.subnetMask = new JTextField();
        this.networkAddress = new JTextField();
        this.broadcastAddress = new JTextField();
        this.noSubnets = new JTextField();
        this.hostsPSubnet = new JTextField();
        this.calBtn = new JButton();
        this.resetBtn = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("IP Address");
        this.jLabel2.setText("CIDR values        /");
        this.jLabel3.setText("Subnet Mask");
        this.jLabel4.setText("Network Address");
        this.jLabel5.setText("Broadcast Address");
        this.jLabel6.setText("Number of Subnets");
        this.jLabel7.setText("Hosts Per Subnet");
        this.jLabel8.setText("Network Class");
        this.networkClass.setEditable(false);
        this.subnetMask.setEditable(false);
        this.networkAddress.setEditable(false);
        this.broadcastAddress.setEditable(false);
        this.calBtn.setText("Calculate");
        this.calBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainCalculator.this.calBtnActionPerformed(evt);
            }
        });
        this.resetBtn.setText("Reset");
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainCalculator.this.resetBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(51, 51, 51).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.oct1, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oct2, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oct3, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oct4, -2, 37, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, 107, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING, -1, 107, Short.MAX_VALUE).addComponent(this.jLabel7, -1, 107, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subnetMask).addComponent(this.networkAddress).addComponent(this.broadcastAddress).addComponent(this.noSubnets).addComponent(this.hostsPSubnet)))).addGap(48, 48, 48).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, 97, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addComponent(this.calBtn, -2, 85, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resetBtn, -2, 71, -2).addComponent(this.cidrValue, -2, 71, -2).addComponent(this.networkClass, -2, 40, -2)).addContainerGap(97, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oct1, -2, -1, -2).addComponent(this.oct2, -2, -1, -2).addComponent(this.oct3, -2, -1, -2).addComponent(this.oct4, -2, -1, -2).addComponent(this.jLabel1, -2, 23, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 20, -2).addComponent(this.cidrValue, -2, -1, -2))).addGap(53, 53, 53).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 27, -2).addComponent(this.jLabel8, -2, 27, -2).addComponent(this.networkClass, -2, 27, -2).addComponent(this.subnetMask, -2, 27, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 27, -2).addComponent(this.networkAddress, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -2, 27, -2).addComponent(this.broadcastAddress, -2, 27, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, 27, -2).addComponent(this.noSubnets, -2, 27, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, 27, -2).addComponent(this.hostsPSubnet, -2, 27, -2)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.calBtn, -2, 31, -2).addComponent(this.resetBtn, -2, 31, -2)).addGap(38, 38, 38)));
        this.setSize(new Dimension(642, 424));
        this.setLocationRelativeTo(null);
    }

    private void calBtnActionPerformed(ActionEvent evt) {
        if (!(this.oct1.getText().equals("") || this.oct2.getText().equals("") || this.oct3.getText().equals("") || this.oct4.getText().equals("") || this.cidrValue.getText().equals(""))) {
            int oct1v = Integer.parseInt(this.oct1.getText().toString());
            int oct2v = Integer.parseInt(this.oct2.getText().toString());
            int oct3v = Integer.parseInt(this.oct3.getText().toString());
            int oct4v = Integer.parseInt(this.oct4.getText().toString());
            int cidrv = Integer.parseInt(this.cidrValue.getText().toString());
            switch (cidrv) {
                case 1: {
                    this.subnetMask.setText("128.0.0.0");
                    break;
                }
                case 2: {
                    this.subnetMask.setText("192.0.0.0");
                    break;
                }
                case 3: {
                    this.subnetMask.setText("224.0.0.0");
                    break;
                }
                case 4: {
                    this.subnetMask.setText("240.0.0.0");
                    break;
                }
                case 5: {
                    this.subnetMask.setText("248.0.0.0");
                    break;
                }
                case 6: {
                    this.subnetMask.setText("252.0.0.0");
                    break;
                }
                case 7: {
                    this.subnetMask.setText("254.0.0.0");
                    break;
                }
                case 8: {
                    this.subnetMask.setText("255.0.0.0");
                    break;
                }
                case 9: {
                    this.subnetMask.setText("255.128.0.0");
                    break;
                }
                case 10: {
                    this.subnetMask.setText("255.192.0.0");
                    break;
                }
                case 11: {
                    this.subnetMask.setText("255.224.0.0");
                    break;
                }
                case 12: {
                    this.subnetMask.setText("255.240.0.0");
                    break;
                }
                case 13: {
                    this.subnetMask.setText("255.248.0.0");
                    break;
                }
                case 14: {
                    this.subnetMask.setText("255.252.0.0");
                    break;
                }
                case 15: {
                    this.subnetMask.setText("255.254.0.0");
                    break;
                }
                case 16: {
                    this.subnetMask.setText("255.255.0.0");
                    break;
                }
                case 17: {
                    this.subnetMask.setText("255.255.128.0");
                    break;
                }
                case 18: {
                    this.subnetMask.setText("255.255.192.0");
                    break;
                }
                case 19: {
                    this.subnetMask.setText("255.255.224.0");
                    break;
                }
                case 20: {
                    this.subnetMask.setText("255.255.240.0");
                    break;
                }
                case 21: {
                    this.subnetMask.setText("255.255.248.0");
                    break;
                }
                case 22: {
                    this.subnetMask.setText("255.255.252.0");
                    break;
                }
                case 23: {
                    this.subnetMask.setText("255.255.254.0");
                    break;
                }
                case 24: {
                    this.subnetMask.setText("255.255.255.0");
                    break;
                }
                case 25: {
                    this.subnetMask.setText("255.255.255.128");
                    break;
                }
                case 26: {
                    this.subnetMask.setText("255.255.255.192");
                    break;
                }
                case 27: {
                    this.subnetMask.setText("255.255.255.224");
                    break;
                }
                case 28: {
                    this.subnetMask.setText("255.255.255.240");
                    break;
                }
                case 29: {
                    this.subnetMask.setText("255.255.255.248");
                    break;
                }
                case 30: {
                    this.subnetMask.setText("255.255.255.252");
                    break;
                }
                case 31: {
                    this.subnetMask.setText("255.255.255.254");
                    break;
                }
                case 32: {
                    this.subnetMask.setText("255.255.255.255");
                    break;
                }
                default: {
                    this.cidrValue.setText("Invalid");
                }
            }
            if (oct1v >= 0 && oct1v <= 127) {
                this.networkClass.setText("A");
                this.networkAddress.setText(this.oct1.getText() + ".0.0.0");
            }
            if (oct1v >= 128 && oct1v <= 191) {
                this.networkClass.setText("B");
                this.networkAddress.setText(this.oct1.getText() + "." + this.oct2.getText() + ".0.0");
            }
            if (oct1v >= 192 && oct1v <= 223) {
                this.networkClass.setText("c");
                this.networkAddress.setText(this.oct1.getText() + "." + this.oct2.getText() + "." + this.oct3.getText() + ".0");
            }
            if (oct1v >= 224 && oct1v <= 239) {
                this.networkClass.setText("D");
            }
            if (oct1v >= 240 && oct1v <= 255) {
                this.networkClass.setText("E");
            }
            this.broadcastAddress.setText(this.oct1.getText() + "." + this.oct2.getText() + "." + this.oct3.getText() + ".255");
            int value = 32 - Integer.parseInt(this.cidrValue.getText());
            int outPut = (int)Math.pow(2.0, value);
            this.hostsPSubnet.setText("" + outPut);
            int subnets = Integer.parseInt(this.hostsPSubnet.getText()) / Integer.parseInt(this.cidrValue.getText());
            this.noSubnets.setText("" + subnets);
        } else {
            JOptionPane.showMessageDialog(null, "please enter the missing value!!");
        }
    }

    private void resetBtnActionPerformed(ActionEvent evt) {
        this.oct1.setText("");
        this.oct2.setText("");
        this.oct3.setText("");
        this.oct4.setText("");
        this.cidrValue.setText("");
        this.subnetMask.setText("");
        this.networkAddress.setText("");
        this.broadcastAddress.setText("");
        this.noSubnets.setText("");
        this.hostsPSubnet.setText("");
        this.networkClass.setText("");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainCalculator().setVisible(true);
            }
        });
    }
}

