<?php
	// check this file's MD5 to make sure it wasn't called before
	$prevMD5=@implode('', @file(dirname(__FILE__).'/setup.md5'));
	$thisMD5=md5(@implode('', @file("./updateDB.php")));
	if($thisMD5==$prevMD5){
		$setupAlreadyRun=true;
	}else{
		// set up tables
		if(!isset($silent)){
			$silent=true;
		}

		// set up tables
		setupTable('titles', "create table if not exists `titles` (   `id` INT unsigned not null auto_increment , primary key (`id`), `website_name` VARCHAR(40) , `tagline` VARCHAR(40) , `icon` VARCHAR(40) , `keywords` VARCHAR(220) , `short_description` VARCHAR(200) , `detailed_description` TEXT , `bannertext1` VARCHAR(150) , `bannertext2` VARCHAR(150) , `bannertext3` VARCHAR(150) , `bannertext4` VARCHAR(150) , `address` VARCHAR(40) , `email` VARCHAR(80) , `phone` VARCHAR(40) , `googlemap` VARCHAR(255) ) CHARSET utf8", $silent);
		setupTable('links', "create table if not exists `links` (   `id` INT unsigned not null auto_increment , primary key (`id`), `facebook` VARCHAR(40) , `twitter` VARCHAR(40) , `googleplus` VARCHAR(40) , `pinterest` VARCHAR(40) , `dribble` VARCHAR(40) , `comments_script` TEXT , `sharing_script` TEXT , `javascript` TEXT ) CHARSET utf8", $silent, array( " ALTER TABLE `links` CHANGE `javascript` `javascript` TEXT "));
		setupTable('blog_categories', "create table if not exists `blog_categories` (   `id` INT unsigned not null auto_increment , primary key (`id`), `name` VARCHAR(40) not null ) CHARSET utf8", $silent);
		setupTable('blogs', "create table if not exists `blogs` (   `id` INT unsigned not null auto_increment , primary key (`id`), `title` VARCHAR(190) not null , `category` INT unsigned not null , `tags` VARCHAR(40) not null , `content` TEXT not null , `photo` VARCHAR(50) not null , `date` DATE , `author` VARCHAR(40) , `posted` VARCHAR(40) not null ) CHARSET utf8", $silent);
		setupIndexes('blogs', array('category'));
		setupTable('editors_choice', "create table if not exists `editors_choice` (   `id` INT unsigned not null auto_increment , primary key (`id`), `blog` INT unsigned not null ) CHARSET utf8", $silent);
		setupIndexes('editors_choice', array('blog'));


		// save MD5
		if($fp=@fopen(dirname(__FILE__).'/setup.md5', 'w')){
			fwrite($fp, $thisMD5);
			fclose($fp);
		}
	}


	function setupIndexes($tableName, $arrFields){
		if(!is_array($arrFields)){
			return false;
		}

		foreach($arrFields as $fieldName){
			if(!$res=@db_query("SHOW COLUMNS FROM `$tableName` like '$fieldName'")){
				continue;
			}
			if(!$row=@db_fetch_assoc($res)){
				continue;
			}
			if($row['Key']==''){
				@db_query("ALTER TABLE `$tableName` ADD INDEX `$fieldName` (`$fieldName`)");
			}
		}
	}


	function setupTable($tableName, $createSQL='', $silent=true, $arrAlter=''){
		global $Translation;
		ob_start();

		echo '<div style="padding: 5px; border-bottom:solid 1px silver; font-family: verdana, arial; font-size: 10px;">';

		// is there a table rename query?
		if(is_array($arrAlter)){
			$matches=array();
			if(preg_match("/ALTER TABLE `(.*)` RENAME `$tableName`/", $arrAlter[0], $matches)){
				$oldTableName=$matches[1];
			}
		}

		if($res=@db_query("select count(1) from `$tableName`")){ // table already exists
			if($row = @db_fetch_array($res)){
				echo str_replace("<TableName>", $tableName, str_replace("<NumRecords>", $row[0],$Translation["table exists"]));
				if(is_array($arrAlter)){
					echo '<br>';
					foreach($arrAlter as $alter){
						if($alter!=''){
							echo "$alter ... ";
							if(!@db_query($alter)){
								echo '<span class="label label-danger">' . $Translation['failed'] . '</span>';
								echo '<div class="text-danger">' . $Translation['mysql said'] . ' ' . db_error(db_link()) . '</div>';
							}else{
								echo '<span class="label label-success">' . $Translation['ok'] . '</span>';
							}
						}
					}
				}else{
					echo $Translation["table uptodate"];
				}
			}else{
				echo str_replace("<TableName>", $tableName, $Translation["couldnt count"]);
			}
		}else{ // given tableName doesn't exist

			if($oldTableName!=''){ // if we have a table rename query
				if($ro=@db_query("select count(1) from `$oldTableName`")){ // if old table exists, rename it.
					$renameQuery=array_shift($arrAlter); // get and remove rename query

					echo "$renameQuery ... ";
					if(!@db_query($renameQuery)){
						echo '<span class="label label-danger">' . $Translation['failed'] . '</span>';
						echo '<div class="text-danger">' . $Translation['mysql said'] . ' ' . db_error(db_link()) . '</div>';
					}else{
						echo '<span class="label label-success">' . $Translation['ok'] . '</span>';
					}

					if(is_array($arrAlter)) setupTable($tableName, $createSQL, false, $arrAlter); // execute Alter queries on renamed table ...
				}else{ // if old tableName doesn't exist (nor the new one since we're here), then just create the table.
					setupTable($tableName, $createSQL, false); // no Alter queries passed ...
				}
			}else{ // tableName doesn't exist and no rename, so just create the table
				echo str_replace("<TableName>", $tableName, $Translation["creating table"]);
				if(!@db_query($createSQL)){
					echo '<span class="label label-danger">' . $Translation['failed'] . '</span>';
					echo '<div class="text-danger">' . $Translation['mysql said'] . db_error(db_link()) . '</div>';
				}else{
					echo '<span class="label label-success">' . $Translation['ok'] . '</span>';
				}
			}
		}

		echo "</div>";

		$out=ob_get_contents();
		ob_end_clean();
		if(!$silent){
			echo $out;
		}
	}
?>